function FontObject()
{
	this.main = LoadFont("Main.rfn");
	this.little = LoadFont("Little.rfn");
	this.title = LoadFont("Title.rfn");
}

FontObject.prototype.drawText = function(x, y, text, alignment, color)
{
	if (typeof text == "number")
	{
		text = text.toString();
	}
	if (color == undefined)
	{
		color = colors.white;
	}
	this.main.setColorMask(color);
	switch (alignment)
	{
		case "right":
			this.main.drawText(x - this.main.getStringWidth(text), y, text);
			break;
		case "center":
			this.main.drawText(x - Math.floor(this.main.getStringWidth(text) / 2), y, text);
			break;
		default:
			this.main.drawText(x, y, text);
			break;
	}
}

FontObject.prototype.iconText = function(x, y, text, icon, alignment, color)
{
	if (typeof text == "number")
	{
		text = text.toString();
	}
	if (color == undefined)
	{
		color = colors.white;
	}
	this.main.setColorMask(color);
	switch (alignment)
	{
		case "right":
			break;
		case "center":
			icon.blit(x - Math.floor((this.main.getStringWidth(text) + icon.width) / 2), y);
			this.main.drawText(x + icon.width + 2 - Math.floor((this.main.getStringWidth(text) + icon.width) / 2), y, text);
			break;
		default:
			icon.blit(x, y);
			this.main.drawText(x + icon.width + 2, y, text);
			break;
	}
}

FontObject.prototype.littleText = function(x, y, text, alignment, color)
{
	if (typeof text == "number")
	{
		text = text.toString();
	}
	if (color == undefined)
	{
		color = colors.white;
	}
	this.little.setColorMask(color);
	var xm = 0;
	switch (alignment)
	{
		case "right":
			xm = this.getLittleWidth(text);
			break;
		case "center":
			xm = (this.getLittleWidth(text)) / 2;
			break;
		default:
			xm = 0;
			break;
	}
	for (var i = 0; i < text.length; i ++)
	{
		this.little.drawText(x - xm + this.little.getStringWidth(text.substr(0, i)) - i, y, text.substr(i, 1));
	}
}

FontObject.prototype.getLittleWidth = function(text)
{
	return this.little.getStringWidth(text) - text.length;
}

FontObject.prototype.messageText = function(x, y, w, h, text, thought)
{
	if (thought == 1)
	{
		this.main.setColorMask(system.thoughtColor);
	}
	else
		this.main.setColorMask(system.textColor);
	this.main.drawTextBox(x, y, w, h, 0, text);
}

var font = new FontObject();